﻿﻿/*----------------------------------------------------------------
             文件名：main.js
             文件功能描述：主页自适应、样式处理和事件添加
----------------------------------------------------------------*/

$(function(){
	autoResize();
	$(window).resize(function(){autoResize();});
	main_ctrl.init("view");
	//设备树基本配置
	initPageEvent();
	addTopBarEvent();
	initDownTool();
})

/**
* 初始化页面点击事件
* @author jq_zhang
*/
function initPageEvent(){
	$("#addLocalMapBtn,#addLocalMapDownBtn").click(function(){main_ctrl.addLocalMap();});//添加主地图
	$("#zTreeDoSearch").click(function(){main_ctrl.treeSearch();}); //设备数查询按钮
	$("#zTreeSearchKey").keyup(function(){main_ctrl.treeSearch();});//设备树自动查询
	$("#zTreeSearchKey").change(function(){main_ctrl.treeSearch();});//设备树自动查询
	$("#addLocalMapBtn,#addLocalMapDownBtn").click(function(){main_ctrl.addLocalMap();});//添加主地图
	$("#addChildMapBtn,#addChildMapDownBtn").click(function(){main_ctrl.addChildMap();});//添加子地图
	$("#updateLocalMapBtn,#updateLocalMapDownBtn").click(function(){main_ctrl.updateCurMap();});//更新当前地图
	$("#delLocalMapBtn,#delLocalMapDownBtn").click(function(){//删除当前地图
		 $.dialog({
            title: bitmap_lang.js.confirm,
            lock: true,
            icon: 'warning.png',
            content: bitmap_lang.js.confirmDelCurmap,
			ok:function(){main_ctrl.delCurMap();},
			cancel:function(){},
			okVal:bitmap_lang.js.yes,
			cancelVal:bitmap_lang.js.no
         });
	});
	$("#delDevBtn,#delDevDownBtn").click(function(){main_ctrl.delDevice();});//删除选中设备
	$("#updateChildMapBtn,#updateChildMapDownBtn").click(function(){main_ctrl.updateChildMap();});//修改热区
	$("#delChildMapBtn,#delChildMapDownBtn").click(function(){main_ctrl.delChildMap();});//删除热区
	$("#goBackBtn").click(function(){main_ctrl.goBack();});//返回
	$("#toggleBar").click(function(){toggleInfoBar();});
	bindKeyDown();
	$("input").keydown(function(){
		$(document).unbind("keydown");
	}).focus(function(){
		$(document).unbind("keydown");
	}).blur(function(){
		bindKeyDown();
	});
}


/**
* 顶部菜单事件添加
* @author jq_zhang
*/
function addTopBarEvent(){
	$("a[page]").click(function(){
		if(main_ctrl.curPage && main_ctrl.curPage==$(this).attr("page")){
			return;
		}
		$("a[page]").each(function(){
			$(this).parent().removeClass("current");
		});
		main_ctrl.viewPageInit();
		main_ctrl.curPage = $(this).attr("page");
		main_ctrl.resetPage(); 
		$(this).parent().addClass("current");
	});
	$("a[page]").focus(function(){
		$(this).blur();
	});
}


/**
* 右侧信息栏隐藏显示切换
* @author jq_zhang
*/
function toggleInfoBar(){
	if($("#toggleBar").attr("showFlag")=="true"){
		$("#toggleBar").attr("showFlag","false");
		$("#sideBar").hide();
		$("#sideBar").width(0);
		$("#toggleBar").removeClass("toggle-bar-close").addClass("toggle-bar-open");
	}else{
		$("#toggleBar").attr("showFlag","true");
		$("#sideBar").show();
		$("#sideBar").width(300);
		$("#toggleBar").removeClass("toggle-bar-open").addClass("toggle-bar-close");
	}
	autoResize();
}

/**
* 下拉工具栏初始化
* @author jq_zhang
*/
function initDownTool(){
	$("#toolBtn").mouseover(function(){
		$("#downTool").show();
	});
	$("#toolBtn").mouseout(function(event){
		if(!$("#downTool")[0].contains(event.toElement)){
			$("#downTool").hide();
		}
	});
	$("#downTool").mouseout(function(event){
		if(!$("#downTool")[0].contains(event.toElement)){
			$("#downTool").hide();
		}
	});
}

/**
* 样式自适应
* @author jq_zhang
*/
function autoResize() {
	//地图和右侧信息栏大小控制
	var client_w = $(window).width();
	var client_h = $(window).height();
	if(client_h<550){
		client_h = 550;
		$("html").css("overflow-y","auto");
	}else{
		$("html").css("overflow-y","hidden");
	}
	if(client_w<800){
		client_w = 800;
		$("html").css("overflow-x","auto");
	}else{
		$("html").css("overflow-x","hidden");
	}
	if(client_w<1100){
		$("#normalEditBar").hide();
		$("#specialEditBar").show();
	}else{
		$("#normalEditBar").show();
		$("#specialEditBar").hide();
	}
	$("#wrapper").height(client_h).width(client_w);
	$("#lockMapForAdd").height(client_h).width(client_w).children(0).css({"top":client_h/2-50,"left":client_w/2-150});
	$("#sideBar").height($("#wrapper").height());
	$("#workBox").width($("#wrapper").width()-$("#sideBar").width()-$("#toggleBar").width()-14)
				 .height($("#wrapper").height()-12);
	$("#toggleBar").height($("#wrapper").height()).css("left",$("#workBox").width()+6)
	$("#sideBar").css("left",$("#workBox").width()+$("#toggleBar").width()+6)
	$("#map").width($("#workBox").width()-2).height($("#workBox").height()-$("#toolbar").height()-2);
	$("#sideWorkBox").height($("#sideBar").height()-$("#devTabs").height()-23);
	$("#sideContentWrap").height($("#sideWorkBox").height()-45).find(".dev-tree-div").height($("#sideContentWrap").height()-20);
	$("#downTool").css({
		top:$("#toolbar").height()-2,
		left:$("#workBox").width()-98
	});
	main_ctrl.refreshMap();
}

/**
* 绑定键盘事件
* @author wang_qing
*/
function bindKeyDown(){
	$(document).unbind("keydown").bind("keydown",function(evt){
		if(!evt) evt = event
		var keycode = evt.keyCode;
		if(8 == keycode){//Backspace
			return false;
		}
	});
}